/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.action;

import com.group_finity.mascot.Mascot;
import com.group_finity.mascot.action.ActionBase;
import com.group_finity.mascot.animation.Animation;
import com.group_finity.mascot.exception.LostGroundException;
import com.group_finity.mascot.exception.VariableException;
import com.group_finity.mascot.script.VariableMap;
import java.awt.Point;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class Fall
extends ActionBase {
    private static final Logger log = Logger.getLogger(Fall.class.getName());
    public static final String PARAMETER_INITIALVX = "InitialVX";
    private static final int DEFAULT_INITIALVX = 0;
    private static final String PARAMETER_INITIALVY = "InitialVY";
    private static final int DEFAULT_INITIALVY = 0;
    public static final String PARAMETER_RESISTANCEX = "ResistanceX";
    private static final double DEFAULT_RESISTANCEX = 0.05;
    public static final String PARAMETER_RESISTANCEY = "ResistanceY";
    private static final double DEFAULT_RESISTANCEY = 0.1;
    public static final String PARAMETER_GRAVITY = "Gravity";
    private static final double DEFAULT_GRAVITY = 2.0;
    public static final String VARIABLE_VELOCITYX = "VelocityX";
    public static final String VARIABLE_VELOCITYY = "VelocityY";
    private double velocityX;
    private double velocityY;
    private double modX;
    private double modY;

    public Fall(ResourceBundle schema, List<Animation> animations, VariableMap context) {
        super(schema, animations, context);
    }

    @Override
    public void init(Mascot mascot) throws VariableException {
        super.init(mascot);
        this.setVelocityX(this.getInitialVx());
        this.setVelocityY(this.getInitialVy());
    }

    @Override
    public boolean hasNext() throws VariableException {
        Point pos = this.getMascot().getAnchor();
        boolean onBorder = false;
        if (this.getEnvironment().getFloor().isOn(pos)) {
            onBorder = true;
        }
        if (this.getEnvironment().getWall().isOn(pos)) {
            onBorder = true;
        }
        return super.hasNext() && !onBorder;
    }

    @Override
    protected void tick() throws LostGroundException, VariableException {
        if (this.getVelocityX() != 0.0) {
            this.getMascot().setLookRight(this.getVelocityX() > 0.0);
        }
        this.setVelocityX(this.getVelocityX() - this.getVelocityX() * this.getResistanceX());
        this.setVelocityY(this.getVelocityY() - this.getVelocityY() * this.getResistanceY() + this.getGravity());
        this.putVariable(this.getSchema().getString(VARIABLE_VELOCITYX), this.getVelocityX());
        this.putVariable(this.getSchema().getString(VARIABLE_VELOCITYY), this.getVelocityY());
        this.setModX(this.getModX() + this.getVelocityX() % 1.0);
        this.setModY(this.getModY() + this.getVelocityY() % 1.0);
        int dx = (int)this.getVelocityX() + (int)this.getModX();
        int dy = (int)this.getVelocityY() + (int)this.getModY();
        this.setModX(this.getModX() % 1.0);
        this.setModY(this.getModY() % 1.0);
        int dev = Math.max(1, Math.max(Math.abs(dx), Math.abs(dy)));
        Point start = this.getMascot().getAnchor();
        block0: for (int i = 0; i <= dev; ++i) {
            int x = start.x + dx * i / dev;
            int y = start.y + dy * i / dev;
            this.getMascot().setAnchor(new Point(x, y));
            if (dy > 0) {
                for (int j = -80; j <= 0; ++j) {
                    this.getMascot().setAnchor(new Point(x, y + j));
                    if (this.getEnvironment().getFloor(true).isOn(this.getMascot().getAnchor())) break block0;
                }
            }
            if (this.getEnvironment().getWall(true).isOn(this.getMascot().getAnchor())) break;
        }
        this.getAnimation().next(this.getMascot(), this.getTime());
    }

    private int getInitialVx() throws VariableException {
        return ((Number)this.eval(this.getSchema().getString(PARAMETER_INITIALVX), Number.class, 0)).intValue();
    }

    private int getInitialVy() throws VariableException {
        return ((Number)this.eval(this.getSchema().getString(PARAMETER_INITIALVY), Number.class, 0)).intValue();
    }

    private double getGravity() throws VariableException {
        return ((Number)this.eval(this.getSchema().getString(PARAMETER_GRAVITY), Number.class, 2.0)).doubleValue();
    }

    private double getResistanceX() throws VariableException {
        return ((Number)this.eval(this.getSchema().getString(PARAMETER_RESISTANCEX), Number.class, 0.05)).doubleValue();
    }

    private double getResistanceY() throws VariableException {
        return ((Number)this.eval(this.getSchema().getString(PARAMETER_RESISTANCEY), Number.class, 0.1)).doubleValue();
    }

    private void setVelocityY(double velocityY) {
        this.velocityY = velocityY;
    }

    private double getVelocityY() {
        return this.velocityY;
    }

    private void setVelocityX(double velocityX) {
        this.velocityX = velocityX;
    }

    private double getVelocityX() {
        return this.velocityX;
    }

    private void setModX(double modX) {
        this.modX = modX;
    }

    private double getModX() {
        return this.modX;
    }

    private void setModY(double modY) {
        this.modY = modY;
    }

    private double getModY() {
        return this.modY;
    }
}

